VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton Command1 
      Caption         =   "Create Table"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Sub Command1_Click()
   Call pdf.CreateNewPDF(vbNullString)  ' The ouput file is opened later

   Call pdf.SetPageCoords(pcTopDown)
   Call pdf.SetResolution(300)

   Dim i, rowNum As Integer

   Dim tbl As CPDFTable
   Set tbl = New CPDFTable
   Call tbl.CreateTable(pdf, 3, 3, 500#, 100#)
   Call tbl.SetBoxProperty(-1, -1, tbpBorderWidth, 1#, 1#, 1#, 1#)
   Call tbl.SetFont(-1, -1, "Arial", fsRegular, True, cp1252)
   Call tbl.SetFont(-1, 1, "Arial", fsBold, True, cp1252)
   Call tbl.SetGridWidth(1#, 1#)

   Dim Text As String
   Text = "The cell alignment can be set for text, images, and templates..."

   ' -1.0 means use the default row height as specified in the CreateTable() call.
   rowNum = tbl.AddRow(-1#)
   Call tbl.SetCellText(rowNum, 0, taLeft, coTop, Text)
   Call tbl.SetCellText(rowNum, 1, taCenter, coTop, Text)
   Call tbl.SetCellText(rowNum, 2, taRight, coTop, Text)

   rowNum = tbl.AddRow(-1#)
   Call tbl.SetCellText(rowNum, 0, taLeft, coCenter, Text)
   Call tbl.SetCellText(rowNum, 1, taCenter, coCenter, Text)
   Call tbl.SetCellText(rowNum, 2, taRight, coCenter, Text)

   rowNum = tbl.AddRow(-1#)
   Call tbl.SetCellText(rowNum, 0, taLeft, coBottom, Text)
   Call tbl.SetCellText(rowNum, 1, taCenter, coBottom, Text)
   Call tbl.SetCellText(rowNum, 2, taRight, coBottom, Text)

   ' Draw the table now
   pdf.Append
   Call tbl.DrawTable(50#, 50#, 742#)
   While tbl.HaveMore()
      pdf.EndPage
      pdf.Append
      Call tbl.DrawTable(50#, 50#, 742#)
   Wend
   pdf.EndPage


   ' Let's change the cell orientation to see what happens...
   Call tbl.SetCellOrientation(-1, -1, 90)
   pdf.Append
   Call pdf.SetFont("Arial", fsRegular, 12#, True, cp1252)
   Call pdf.WriteText(50#, 50#, "The same table but the cell orientation was changed to 90 degrees.")

   Call tbl.DrawTable(50#, 65#, 742#)
   While tbl.HaveMore()
      pdf.EndPage
      pdf.Append
      Call tbl.DrawTable(50#, 50#, 737#)
   Wend
   pdf.EndPage

   Set tbl = Nothing

   ' A table stores errors and warnings in the error log
   Dim pdferr As TPDFError

   n = pdf.GetErrLogMessageCount()
   For i = 0 To n - 1
      Call pdf.GetErrLogMessage(i, pdferr)
      MsgBox pdferr.Message, vbExclamation, "Warning"
   Next i

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(outFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
